//=============================================================================
// MedKit.
//=============================================================================
class HolyMedKit extends DeusExPickup;

#exec TEXTURE IMPORT NAME=HolyMedkit FILE=Textures\HolyMedkit.PCX GROUP=skins //Skin

// ----------------------------------------------------------------------
state Activated
{
	function Activate()
	{
		local DeusExPlayer player;
		
		player = DeusExPlayer(Owner);
		
			player.HealPlayer(600, False);
			player.StopPoison();
			player.ExtinguishFire();
			player.drugEffectTimer = 0;

		PlaySound(sound'MedicalHiss', SLOT_None,255,, 64);
	}

	function BeginState()
	{
		local DeusExPlayer player;
		
		player = DeusExPlayer(Owner);
		
			player.HealPlayer(600, False);
			player.StopPoison();
			player.ExtinguishFire();
			player.drugEffectTimer = 0;

		PlaySound(sound'MedicalHiss', SLOT_None,255,, 64);
	}
Begin:
}


// ----------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 9);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     maxCopies=1
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="The Holy Medkit"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.MedKit'
     PickupViewMesh=LodMesh'DeusExItems.MedKit'
     ThirdPersonMesh=LodMesh'DeusExItems.MedKit3rd'
     LandSound=Sound'DeusExSounds.Generic.PlasticHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconMedKit'
     largeIcon=Texture'DeusExUI.Icons.LargeIconMedKit'
     largeIconWidth=39
     largeIconHeight=46
     Description="A single medkit that lasts forever."
     beltDescription="HOLY MED"
     Mesh=LodMesh'DeusExItems.MedKit'
     Skin=Texture'HolyMedkit'
     CollisionRadius=7.500000
     CollisionHeight=1.000000
     Mass=10.000000
     Buoyancy=8.000000
}
